/**
 * Deze klasse beschrijft een heel eenvoudige geldautomaat waarin je muntstukken
 * werpt.
 *
 * @author Dominiek Vandewalle
 * @version 2014-08-27
 */
public class GeldAutomaatAdvanced
{
    // velden
    private double bedragInAutomaat;//Totaal ingeworpen bedrag.
    private int aantalMuntstukkenInAutomaat;//Aantal muntstukken in automaat.
    
    /**
     * Constructor voor objecten van Klasse GeldAutomaatAdvanced.
     */
    public GeldAutomaatAdvanced()
    {
        bedragInAutomaat = 0;
        aantalMuntstukkenInAutomaat = 0;
    }
    
    /**
     * Toont het totale bedrag dat in de geldautomaat zit.

     * @return    Geeft het totale bedrag in de geldautomaat terug.
     */
    public double getBedragInAutomaat()
    {
        return bedragInAutomaat;
    }

     /**
     * Toont hoeveel muntstukken in de geldautomaat zitten.
     * @return    Geeft het aantal muntstukken in de geldautomaat terug.
     */
    public int getAantalMuntstukkenInAutomaat()
    {
        return aantalMuntstukkenInAutomaat;
    }
    
    /**
     * Werpt een munstuk van een zeker bedrag in de geldautomaat.
     * @param  muntstuk    Het bedrag van het muntstuk dat ingeworpen wordt.
     */
    public void werpMuntstukInAutomaat(double muntstuk)
    {
        // ingeworpen bedrag bij totale bedrag in automaat tellen.
        bedragInAutomaat = bedragInAutomaat + muntstuk;
        aantalMuntstukkenInAutomaat++;
    }
    
    /**
     * Geeft al het geld in de geldautomaat terug. Er blijft 0 euro over.
     * @return    Geeft het aanwezige bedrag in de automaat terug.
     */
    public double resetAutomaat()
    {
        double hulp;
        hulp = bedragInAutomaat;
        bedragInAutomaat = 0;
        aantalMuntstukkenInAutomaat = 0;
        return hulp;
    }
    
    /**
     * Toont informatie over de automaat in het terminalvenster.
     */
    public void printInfo()
    {
        String info;
        info = "Totaal bedrag:" + bedragInAutomaat + " euro\n";  
        info += "Aantal munten:" + aantalMuntstukkenInAutomaat;
        System.out.println(info);
    }
}